<?php
/**
 * Simple Hash Test
 */

$password = 'admin123';
$known_good_hashes = [
    // Laravel'in "password" için kullandığı hash
    '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi',
    // Başka bir bilinen hash
    '$2y$12$LQv3c1yqBWVHxkd0LHAkCOYz6TtxMQJqhN8/LewdBPj3zzlqfz7FK'
];

echo "<h2>Hash Test Sonuçları</h2>";
echo "<p>Test Şifresi: <strong>$password</strong></p>";

foreach ($known_good_hashes as $i => $hash) {
    echo "<h3>Hash " . ($i + 1) . ":</h3>";
    echo "<code>$hash</code><br>";
    
    if (password_verify($password, $hash)) {
        echo "<span style='color: green; font-weight: bold;'>✅ ÇALIŞIYOR!</span><br><br>";
        
        // Bu hash çalışıyorsa SQL komutunu göster
        echo "<div style='background: #d4edda; padding: 10px; border: 1px solid #c3e6cb; margin: 10px 0;'>";
        echo "<strong>Bu hash'i kullanın:</strong><br>";
        echo "<textarea style='width: 100%; height: 60px;'>";
        echo "UPDATE users SET password_hash = '$hash' WHERE username = 'admin';";
        echo "</textarea>";
        echo "</div>";
        break;
    } else {
        echo "<span style='color: red;'>❌ Çalışmıyor</span><br><br>";
    }
}

// Yeni hash oluştur ve test et
echo "<h3>Yeni Hash Oluştur:</h3>";
$new_hash = password_hash($password, PASSWORD_BCRYPT);
echo "<code>$new_hash</code><br>";

if (password_verify($password, $new_hash)) {
    echo "<span style='color: green; font-weight: bold;'>✅ YENİ HASH ÇALIŞIYOR!</span><br>";
    echo "<div style='background: #d4edda; padding: 10px; border: 1px solid #c3e6cb; margin: 10px 0;'>";
    echo "<strong>Bu yeni hash'i kullanın:</strong><br>";
    echo "<textarea style='width: 100%; height: 60px;'>";
    echo "UPDATE users SET password_hash = '$new_hash' WHERE username = 'admin';";
    echo "</textarea>";
    echo "</div>";
} else {
    echo "<span style='color: red;'>❌ Yeni hash çalışmıyor</span><br>";
}

echo "<hr>";
echo "<p><strong>PHP Versiyonu:</strong> " . PHP_VERSION . "</p>";
echo "<p><strong>BCRYPT:</strong> " . (defined('PASSWORD_BCRYPT') ? 'Destekleniyor' : 'Desteklenmiyor') . "</p>";
?>

<div style="background: #f8f9fa; padding: 15px; border: 1px solid #dee2e6; margin: 20px 0;">
    <h4>🔧 Çözüm Adımları</h4>
    <ol>
        <li>Bu sayfadaki yeşil ✅ işareti olan hash'i kopyalayın</li>
        <li>phpMyAdmin'e gidin</li>
        <li>SQL sekmesinde gösterilen UPDATE komutunu çalıştırın</li>
        <li>admin/admin123 ile giriş yapmayı deneyin</li>
    </ol>
</div>