<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Alpi Diş Hastaneleri CRM</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Custom CSS -->
    <link href="/public/assets/css/style.css" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/public/assets/images/favicon.ico">
</head>
<body>
    <?php 
    require_once __DIR__ . '/../config/config.php';
    
    // Check if user is logged in for protected pages
    if (!isset($public_page) || !$public_page) {
        Auth::requireLogin();
    }
    ?>
    
    <!-- Modern Navigation Header -->
    <?php if (Auth::isLoggedIn()): ?>
    <nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom sticky-top">
        <div class="container-fluid px-4">
            <!-- Mobile Sidebar Toggle -->
            <button class="btn btn-link d-md-none me-2 p-0" type="button" id="sidebarToggle">
                <i class="fas fa-bars"></i>
            </button>
            
            <a class="navbar-brand" href="/public/dashboard.php">
                <i class="fas fa-tooth"></i>
                Alpi CRM
            </a>
            
            <!-- Mobile Toggle -->
            <button class="navbar-toggler border-0 p-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <i class="fas fa-ellipsis-v"></i>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <!-- Search Bar (Optional) -->
                <div class="d-none d-lg-flex mx-auto" style="max-width: 400px; width: 100%;">
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-end-0">
                            <i class="fas fa-search text-muted"></i>
                        </span>
                        <input type="text" class="form-control border-start-0" placeholder="Hasta ara...">
                    </div>
                </div>
                
                <!-- User Menu -->
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle d-flex align-items-center pe-0" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm me-2">
                                    <div class="avatar-circle">
                                        <?php echo strtoupper(substr($_SESSION['full_name'], 0, 1)); ?>
                                    </div>
                                </div>
                                <div class="d-none d-lg-block text-start">
                                    <div class="fw-semibold"><?php echo htmlspecialchars($_SESSION['full_name']); ?></div>
                                    <small class="text-muted">
                                        <?php 
                                        $roles = [
                                            'owner' => 'Patron',
                                            'admin' => 'Yönetici', 
                                            'sales' => 'Satış',
                                            'callcenter' => 'Çağrı Merkezi'
                                        ];
                                        echo $roles[$_SESSION['role']] ?? $_SESSION['role'];
                                        ?>
                                    </small>
                                </div>
                                <i class="fas fa-chevron-down ms-2 small"></i>
                            </div>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end shadow-lg border-0">
                            <li class="dropdown-header">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-sm me-2">
                                        <div class="avatar-circle">
                                            <?php echo strtoupper(substr($_SESSION['full_name'], 0, 1)); ?>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="fw-semibold"><?php echo htmlspecialchars($_SESSION['full_name']); ?></div>
                                        <small class="text-muted"><?php echo htmlspecialchars($_SESSION['email']); ?></small>
                                    </div>
                                </div>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="/modules/users/profile.php">
                                <i class="fas fa-user"></i>Profil
                            </a></li>
                            <li><a class="dropdown-item" href="/modules/users/settings.php">
                                <i class="fas fa-cog"></i>Ayarlar
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="/modules/users/logout.php">
                                <i class="fas fa-sign-out-alt"></i>Çıkış
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <!-- Modern Layout Container -->
    <div class="d-flex">
        <!-- Modern Sidebar -->
        <nav class="sidebar" id="sidebar">
            <div class="sidebar-content">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'dashboard.php') ? 'active' : ''; ?>" 
                           href="/public/dashboard.php">
                            <i class="fas fa-home"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                    
                    <?php if (Auth::hasRole(Auth::ROLE_SALES) || Auth::hasRole(Auth::ROLE_ADMIN) || Auth::hasRole(Auth::ROLE_OWNER)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo (strpos($_SERVER['PHP_SELF'], '/patients/') !== false) ? 'active' : ''; ?>" 
                           href="/modules/patients/list.php">
                            <i class="fas fa-users"></i>
                            <span>Hastalar</span>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (Auth::hasRole(Auth::ROLE_CALLCENTER) || Auth::hasRole(Auth::ROLE_ADMIN) || Auth::hasRole(Auth::ROLE_OWNER)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo (strpos($_SERVER['PHP_SELF'], '/followups/') !== false) ? 'active' : ''; ?>" 
                           href="/modules/followups/list.php">
                            <i class="fas fa-phone"></i>
                            <span>Follow-Up</span>
                            <?php
                            // Get pending followup count for badge
                            try {
                                $db = getDB();
                                $sql = "SELECT COUNT(*) as count FROM patients WHERE followup_date <= CURDATE() AND status = 'pending'";
                                if (!Auth::hasRole(Auth::ROLE_OWNER)) {
                                    $sql .= " AND branch_id = ?";
                                    $stmt = $db->prepare($sql);
                                    $stmt->execute([$_SESSION['branch_id']]);
                                } else {
                                    $stmt = $db->prepare($sql);
                                    $stmt->execute();
                                }
                                $result = $stmt->fetch();
                                if ($result['count'] > 0) {
                                    echo '<span class="badge badge-danger">' . $result['count'] . '</span>';
                                }
                            } catch (Exception $e) {
                                // Silent fail
                            }
                            ?>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (Auth::hasRole(Auth::ROLE_ADMIN) || Auth::hasRole(Auth::ROLE_OWNER)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo (strpos($_SERVER['PHP_SELF'], '/reports/') !== false) ? 'active' : ''; ?>" 
                           href="/modules/reports/dashboard.php">
                            <i class="fas fa-chart-line"></i>
                            <span>Raporlar</span>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (Auth::hasRole(Auth::ROLE_ADMIN) || Auth::hasRole(Auth::ROLE_OWNER)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo (strpos($_SERVER['PHP_SELF'], '/activity_log/') !== false) ? 'active' : ''; ?>" 
                           href="/modules/activity_log/list.php">
                            <i class="fas fa-history"></i>
                            <span>İşlem Geçmişi</span>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (Auth::hasRole(Auth::ROLE_OWNER)): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo (strpos($_SERVER['PHP_SELF'], '/users/') !== false && strpos($_SERVER['PHP_SELF'], 'profile.php') === false) ? 'active' : ''; ?>" 
                           href="/modules/users/list.php">
                            <i class="fas fa-users-cog"></i>
                            <span>Kullanıcılar</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
                
                <!-- Branch Info Card -->
                <div class="branch-info">
                    <div class="branch-info-content">
                        <div class="branch-info-item">
                            <i class="fas fa-building"></i>
                            <span>
                                <?php 
                                if (Auth::hasRole(Auth::ROLE_OWNER)) {
                                    echo 'Tüm Şubeler';
                                } else {
                                    echo getBranchName($_SESSION['branch_id']);
                                }
                                ?>
                            </span>
                        </div>
                        <div class="branch-info-item">
                            <i class="fas fa-user-tag"></i>
                            <span>
                                <?php 
                                $roles = [
                                    'owner' => 'Patron',
                                    'admin' => 'Yönetici', 
                                    'sales' => 'Satış',
                                    'callcenter' => 'Çağrı Merkezi'
                                ];
                                echo $roles[$_SESSION['role']] ?? $_SESSION['role'];
                                ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
        
        <!-- Main Content Area -->
        <main class="main-content">
                <!-- Alerts -->
                <?php displayAlerts(); ?>
                
                <!-- Breadcrumb -->
                <?php if (isset($breadcrumb) && !empty($breadcrumb)): ?>
                <nav aria-label="breadcrumb" class="mt-3">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="/public/dashboard.php">Ana Sayfa</a></li>
                        <?php foreach ($breadcrumb as $item): ?>
                            <?php if (isset($item['url'])): ?>
                                <li class="breadcrumb-item"><a href="<?php echo $item['url']; ?>"><?php echo $item['text']; ?></a></li>
                            <?php else: ?>
                                <li class="breadcrumb-item active"><?php echo $item['text']; ?></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ol>
                </nav>
                <?php endif; ?>
    <?php else: ?>
        <!-- Public page content wrapper -->
        <div class="container-fluid">
            <?php displayAlerts(); ?>
    <?php endif; ?>