<?php
/**
 * Alpi Diş Hastaneleri CRM - Password Hash Generator
 * Şifre hash'i oluşturma yardımcı scripti
 */

// admin123 şifresi için doğru hash oluşturalım
$password = 'admin123';

// BCRYPT ile hash oluştur (PHP'de daha yaygın ve stabil)
$bcrypt_hash = password_hash($password, PASSWORD_BCRYPT);

// ARGON2ID ile hash oluştur (daha güvenli ama PHP 7.2+ gerekir)
if (defined('PASSWORD_ARGON2ID')) {
    $argon2id_hash = password_hash($password, PASSWORD_ARGON2ID);
} else {
    $argon2id_hash = 'ARGON2ID desteklenmiyor (PHP 7.2+ gerekli)';
}

echo "Şifre: $password\n\n";
echo "BCRYPT Hash:\n$bcrypt_hash\n\n";
echo "ARGON2ID Hash:\n$argon2id_hash\n\n";

// SQL komutları
echo "SQL Güncelleme Komutları:\n\n";
echo "-- BCRYPT ile güncelleme\n";
echo "UPDATE users SET password_hash = '$bcrypt_hash' WHERE username = 'admin';\n";
echo "UPDATE users SET password_hash = '$bcrypt_hash' WHERE username = 'kaynarca_admin';\n\n";

if (defined('PASSWORD_ARGON2ID')) {
    echo "-- ARGON2ID ile güncelleme\n";
    echo "UPDATE users SET password_hash = '$argon2id_hash' WHERE username = 'admin';\n";
    echo "UPDATE users SET password_hash = '$argon2id_hash' WHERE username = 'kaynarca_admin';\n\n";
}

// Test için
echo "Şifre doğrulama testi:\n";
if (password_verify($password, $bcrypt_hash)) {
    echo "✅ BCRYPT hash doğrulandı\n";
} else {
    echo "❌ BCRYPT hash doğrulanamadı\n";
}

if (defined('PASSWORD_ARGON2ID') && password_verify($password, $argon2id_hash)) {
    echo "✅ ARGON2ID hash doğrulandı\n";
} else {
    echo "❌ ARGON2ID hash doğrulanamadı\n";
}
?>