<?php
/**
 * Emergency Password Reset
 * Acil durum şifre sıfırlama scripti
 */

require_once __DIR__ . '/config/config.php';

echo "<h2>🚨 Acil Durum Şifre Sıfırlama</h2>";

if ($_POST) {
    try {
        $db = getDB();
        
        $username = $_POST['username'];
        $new_password = $_POST['new_password'];
        
        // Yeni hash oluştur
        $new_hash = password_hash($new_password, PASSWORD_BCRYPT);
        
        // Kullanıcı varsa güncelle
        $stmt = $db->prepare("SELECT id FROM users WHERE username = ?");
        $stmt->execute([$username]);
        
        if ($stmt->fetch()) {
            $update_stmt = $db->prepare("UPDATE users SET password_hash = ? WHERE username = ?");
            $update_stmt->execute([$new_hash, $username]);
            
            echo "<div style='color: green; padding: 10px; border: 1px solid green; margin: 10px 0;'>";
            echo "✅ Şifre başarıyla güncellendi!<br>";
            echo "Kullanıcı: $username<br>";
            echo "Yeni Şifre: $new_password<br>";
            echo "Hash: $new_hash<br>";
            echo "</div>";
            
            // Test et
            if (password_verify($new_password, $new_hash)) {
                echo "<p style='color: green;'>✅ Hash doğrulaması başarılı!</p>";
            } else {
                echo "<p style='color: red;'>❌ Hash doğrulaması başarısız!</p>";
            }
            
        } else {
            echo "<p style='color: red;'>❌ Kullanıcı bulunamadı: $username</p>";
        }
        
    } catch (Exception $e) {
        echo "<p style='color: red;'>❌ Hata: " . $e->getMessage() . "</p>";
    }
}
?>

<form method="POST" style="padding: 20px; border: 1px solid #ccc; margin: 20px 0;">
    <h3>Şifre Sıfırla</h3>
    <div style="margin: 10px 0;">
        <label>Kullanıcı Adı:</label><br>
        <input type="text" name="username" value="admin" style="width: 200px; padding: 5px;" required>
    </div>
    <div style="margin: 10px 0;">
        <label>Yeni Şifre:</label><br>
        <input type="text" name="new_password" value="admin123" style="width: 200px; padding: 5px;" required>
    </div>
    <div style="margin: 10px 0;">
        <button type="submit" style="padding: 10px 20px; background: #dc3545; color: white; border: none;">Şifreyi Sıfırla</button>
    </div>
</form>

<div style="background: #fff3cd; padding: 15px; border: 1px solid #ffeaa7; margin: 20px 0;">
    <h4>⚠️ Uyarı</h4>
    <p>Bu script sadece acil durumlarda kullanılmalıdır. Kullandıktan sonra silin!</p>
</div>

<div style="background: #d1ecf1; padding: 15px; border: 1px solid #bee5eb; margin: 20px 0;">
    <h4>📋 Adımlar</h4>
    <ol>
        <li>Bu scripti çalıştırın</li>
        <li>admin kullanıcısı için şifreyi sıfırlayın</li>
        <li>Normal login sayfasından giriş yapın</li>
        <li>Bu dosyayı silin!</li>
    </ol>
</div>