<?php
/**
 * Alpi Diş Hastaneleri CRM - Login Debug Script
 * Giriş sorunlarını test etmek için
 */

require_once __DIR__ . '/config/config.php';

echo "<h2>Alpi CRM - Login Debug</h2>\n";

// Test şifresi
$test_password = 'admin123';
$test_hash = '$2y$10$KoGSNtjlBU63kAByDt5QsefD3.frQb/AwpPO7g4hRKzAupEHg6D4O';

echo "<h3>1. Şifre Hash Testi</h3>\n";
echo "Test Şifresi: $test_password<br>\n";
echo "Test Hash: $test_hash<br>\n";

if (password_verify($test_password, $test_hash)) {
    echo "✅ Şifre hash doğrulaması başarılı<br>\n";
} else {
    echo "❌ Şifre hash doğrulaması başarısız<br>\n";
}

echo "<h3>2. Veritabanı Bağlantı Testi</h3>\n";
try {
    $db = getDB();
    echo "✅ Veritabanına bağlantı başarılı<br>\n";
    
    // Kullanıcıları listele
    $stmt = $db->prepare("SELECT username, SUBSTRING(password_hash, 1, 30) as hash_preview, full_name, role FROM users LIMIT 5");
    $stmt->execute();
    $users = $stmt->fetchAll();
    
    if ($users) {
        echo "<h3>3. Kullanıcı Listesi</h3>\n";
        echo "<table border='1' cellpadding='5'>\n";
        echo "<tr><th>Kullanıcı Adı</th><th>Hash (İlk 30 karakter)</th><th>Ad Soyad</th><th>Rol</th></tr>\n";
        foreach ($users as $user) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($user['username']) . "</td>";
            echo "<td>" . htmlspecialchars($user['hash_preview']) . "...</td>";
            echo "<td>" . htmlspecialchars($user['full_name']) . "</td>";
            echo "<td>" . htmlspecialchars($user['role']) . "</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    } else {
        echo "❌ Veritabanında kullanıcı bulunamadı<br>\n";
    }
    
} catch (Exception $e) {
    echo "❌ Veritabanı hatası: " . $e->getMessage() . "<br>\n";
}

echo "<h3>4. PHP Bilgileri</h3>\n";
echo "PHP Versiyonu: " . PHP_VERSION . "<br>\n";
echo "PASSWORD_BCRYPT: " . (defined('PASSWORD_BCRYPT') ? '✅ Destekleniyor' : '❌ Desteklenmiyor') . "<br>\n";
echo "PASSWORD_ARGON2ID: " . (defined('PASSWORD_ARGON2ID') ? '✅ Destekleniyor' : '❌ Desteklenmiyor') . "<br>\n";

echo "<h3>5. Test Giriş</h3>\n";
if ($_POST) {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    try {
        $stmt = $db->prepare("SELECT id, username, password_hash, full_name, role FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if ($user) {
            echo "✅ Kullanıcı bulundu: " . htmlspecialchars($user['full_name']) . "<br>\n";
            
            if (password_verify($password, $user['password_hash'])) {
                echo "✅ Şifre doğrulandı<br>\n";
                echo "<strong style='color: green;'>GİRİŞ BAŞARILI!</strong><br>\n";
            } else {
                echo "❌ Şifre yanlış<br>\n";
                echo "Girilen şifre: " . htmlspecialchars($password) . "<br>\n";
                echo "Hash: " . substr($user['password_hash'], 0, 50) . "...<br>\n";
            }
        } else {
            echo "❌ Kullanıcı bulunamadı: " . htmlspecialchars($username) . "<br>\n";
        }
    } catch (Exception $e) {
        echo "❌ Giriş testi hatası: " . $e->getMessage() . "<br>\n";
    }
}
?>

<form method="POST" style="margin-top: 20px; padding: 20px; border: 1px solid #ccc;">
    <h4>Giriş Testi</h4>
    <div>
        <label>Kullanıcı Adı:</label><br>
        <input type="text" name="username" value="admin" style="width: 200px; padding: 5px;">
    </div>
    <div style="margin-top: 10px;">
        <label>Şifre:</label><br>
        <input type="password" name="password" value="admin123" style="width: 200px; padding: 5px;">
    </div>
    <div style="margin-top: 10px;">
        <button type="submit" style="padding: 10px 20px; background: #007bff; color: white; border: none;">Test Et</button>
    </div>
</form>

<div style="margin-top: 30px; padding: 15px; background-color: #f8f9fa; border: 1px solid #dee2e6;">
    <h4>Varsayılan Giriş Bilgileri</h4>
    <p><strong>Kullanıcı Adı:</strong> admin</p>
    <p><strong>Şifre:</strong> admin123</p>
    <p><strong>Rol:</strong> Patron (Owner) - Tüm yetkilere sahip</p>
</div>

<div style="margin-top: 20px; padding: 15px; background-color: #fff3cd; border: 1px solid #ffeaa7;">
    <h4>Sorun Giderme Adımları</h4>
    <ol>
        <li>Veritabanının doğru kurulduğunu kontrol edin</li>
        <li>database_schema.sql dosyasını yeniden import edin</li>
        <li>fix_passwords.sql scriptini çalıştırın</li>
        <li>PHP versiyonunun 8.0+ olduğunu kontrol edin</li>
        <li>Web sunucusu hatalarını kontrol edin</li>
    </ol>
</div>