<?php
/**
 * Alpi Diş Hastaneleri CRM - Application Configuration
 * Genel uygulama ayarları ve sabitler
 */

// Error reporting for development
error_reporting(E_ALL);
ini_set('display_errors', 0); // Production için 0 yapın
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');

// Application settings
define('APP_NAME', 'Alpi Diş Hastaneleri CRM');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'https://kb.alpidis.com');
define('UPLOAD_PATH', __DIR__ . '/../uploads/');
define('MAX_UPLOAD_SIZE', 5 * 1024 * 1024); // 5MB

// Timezone
date_default_timezone_set('Europe/Istanbul');

// Branches
$BRANCHES = [
    1 => 'Kaynarca',
    2 => 'Kartal', 
    3 => 'Pendik',
    4 => 'Tuzla'
];

// Patient sources
$PATIENT_SOURCES = [
    'Google',
    'Instagram', 
    'Facebook',
    'Tavsiye',
    'Geçici Hastane',
    'Diğer'
];

// Default reasons for not proceeding
$DEFAULT_REASONS = [
    'Fiyat yüksek geldi',
    'Kredi çıkmadı', 
    'Düşünecek',
    'Rakip kliniğe gitti',
    'Başka şehirde yaşıyor',
    'Zaman bulamadı',
    'Aileden izin alamadı',
    'Diğer'
];

// Patient statuses
$PATIENT_STATUSES = [
    'pending' => [
        'label' => 'Beklemede',
        'class' => 'bg-warning text-dark',
        'icon' => 'clock'
    ],
    'recovered' => [
        'label' => 'Geri Kazanıldı', 
        'class' => 'bg-success',
        'icon' => 'check-circle'
    ],
    'lost' => [
        'label' => 'Kaybedildi',
        'class' => 'bg-danger', 
        'icon' => 'x-circle'
    ]
];

// Follow-up settings
define('DEFAULT_FOLLOWUP_DAYS', 3); // 3 gün sonra geri arama
define('MAX_FOLLOWUP_ATTEMPTS', 3); // Maksimum arama sayısı

// Security settings
define('PASSWORD_MIN_LENGTH', 8);
define('SESSION_TIMEOUT', 1800); // 30 minutes

// Pagination
define('RECORDS_PER_PAGE', 20);

// Include required files
require_once __DIR__ . '/database.php';
require_once __DIR__ . '/auth.php';

// Helper functions
function sanitizeInput($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

function formatDate($date, $format = 'd.m.Y') {
    return date($format, strtotime($date));
}

function formatDateTime($datetime, $format = 'd.m.Y H:i') {
    return date($format, strtotime($datetime));
}

function getBranchName($branch_id) {
    global $BRANCHES;
    return isset($BRANCHES[$branch_id]) ? $BRANCHES[$branch_id] : 'Bilinmeyen';
}

function getPatientStatusBadge($status) {
    global $PATIENT_STATUSES;
    if (!isset($PATIENT_STATUSES[$status])) return '';
    
    $info = $PATIENT_STATUSES[$status];
    return '<span class="badge ' . $info['class'] . '">' . $info['label'] . '</span>';
}

function isValidPhone($phone) {
    // Turkish phone number validation
    $phone = preg_replace('/[^0-9]/', '', $phone);
    return preg_match('/^(5[0-9]{9}|0?5[0-9]{9})$/', $phone);
}

function formatPhone($phone) {
    $phone = preg_replace('/[^0-9]/', '', $phone);
    if (strlen($phone) == 10 && substr($phone, 0, 1) == '5') {
        $phone = '0' . $phone;
    }
    return $phone;
}

function redirectTo($url) {
    header("Location: " . $url);
    exit();
}

function showAlert($message, $type = 'info') {
    $_SESSION['alert'] = ['message' => $message, 'type' => $type];
}

function displayAlerts() {
    if (isset($_SESSION['alert'])) {
        $alert = $_SESSION['alert'];
        echo '<div class="alert alert-' . $alert['type'] . ' alert-dismissible fade show" role="alert">';
        echo htmlspecialchars($alert['message']);
        echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
        echo '</div>';
        unset($_SESSION['alert']);
    }
}

// Create logs directory if not exists
$logsDir = __DIR__ . '/../logs';
if (!is_dir($logsDir)) {
    mkdir($logsDir, 0755, true);
}
?>