# Alpi Diş Hastaneleri CRM - Güvenlik Notları

## 🔒 Önemli Güvenlik Uyarıları

### 1. İlk Kurulumdan Sonra Yapılması Gerekenler

#### Varsayılan Şifreleri Değiştirin
```sql
-- Admin şifresini değiştirin
UPDATE users SET password_hash = ? WHERE username = 'admin';
```

#### Dosya İzinleri
```bash
# Güvenli dosya izinleri
chmod 644 *.php
chmod 755 */
chmod 777 uploads/
chmod 600 config/*.php
```

### 2. Güvenlik Konfigürasyonları

#### PHP.ini Ayarları
```ini
# Güvenlik için önerilen ayarlar
display_errors = Off
log_errors = On
expose_php = Off
session.cookie_httponly = On
session.cookie_secure = On
session.use_strict_mode = On
```

#### .htaccess Koruması
```apache
# config klasörünü koruyun
<Directory "config">
    Order Deny,Allow
    Deny from all
</Directory>

# Log dosyalarını koruyun
<Files "*.log">
    Order Deny,Allow
    Deny from all
</Files>
```

### 3. Güvenlik Kontrol Listesi

#### ✅ Zorunlu Güvenlik Adımları
- [ ] Varsayılan admin şifresi değiştirildi
- [ ] Dosya izinleri doğru ayarlandı
- [ ] SSL sertifikası aktif
- [ ] PHP versiyonu güncel (8.0+)
- [ ] MySQL root şifresi güçlü
- [ ] Backup sistemi kuruldu

#### ⚠️ Önerilen Güvenlik Adımları
- [ ] Firewall kuralları aktif
- [ ] IP whitelist uygulandı
- [ ] Log monitoring sistemi
- [ ] Regular security audit
- [ ] Penetration testing yapıldı

### 4. Hassas Bilgiler

#### Veritabanı Bilgileri
```
Host: localhost
Database: alpidisc_Balik
Username: alpidisc_Balik1
Password: 52Pdcx-B(KfQ!gs9
```

#### İlk Giriş Bilgileri
```
Username: admin
Password: admin123
```

**⚠️ UYARI: Bu bilgileri ilk girişten sonra mutlaka değiştirin!**

### 5. Güvenlik Monitoring

#### Log Dosyaları
- `logs/error.log` - PHP hataları
- `activity_log` tablosu - Kullanıcı aktiviteleri
- Web server access logs

#### Şüpheli Aktiviteler
- Başarısız giriş denemeleri
- SQL injection attempts
- XSS denemesi
- File upload attacks
- Brute force attacks

### 6. Acil Durum Prosedürleri

#### Güvenlik İhlali Durumunda
1. Sistemi hemen offline alın
2. Şifreleri sıfırlayın
3. Log dosyalarını analiz edin
4. Veritabanını yedekten geri yükleyin
5. Güvenlik açığını kapatın

#### Backup ve Recovery
```sql
-- Veritabanı yedeği
mysqldump -u alpidisc_Balik1 -p alpidisc_Balik > backup.sql

-- Geri yükleme
mysql -u alpidisc_Balik1 -p alpidisc_Balik < backup.sql
```

### 7. Düzenli Bakım

#### Haftalık Kontroller
- [ ] Log dosyalarını inceleyin
- [ ] Başarısız giriş denemelerini kontrol edin
- [ ] Sistem performansını ölçün
- [ ] Backup dosyalarını test edin

#### Aylık Kontroller
- [ ] Şifre politikalarını gözden geçirin
- [ ] Kullanıcı erişimlerini audit edin
- [ ] Sistem güncellemelerini uygulayın
- [ ] Güvenlik testleri yapın

### 8. Compliance ve KVKK

#### Veri Koruma
- Hasta bilgileri şifreli saklanıyor
- Erişim logları tutuluyor
- Veri silme politikaları mevcut
- Audit trail aktif

#### KVKK Uyumluluk
- Kişisel veri işleme kayıtları
- Açık rıza mekanizması
- Veri silme hakları
- Güvenlik önlemleri

---

**⚠️ BU DOSYAYI GÜVENLI BİR YERDE SAKLAYIN VE YETKİSİZ KİŞİLERLE PAYLAŞMAYIN!**